package org.msh.tb.indicators;

import org.msh.tb.entities.enums.MessageKey;

/**
 * Factory that builds EnumFilterOption list based on the Enum E values.
 * The list will contain all enum values plus an "undefined" option.
 * @param <E>
 */
public class EnumFilterOptions<E extends MessageKey> {

    private Class<E> clazz;
    EnumFilterOption<E>[] options;

    public EnumFilterOptions(Class<E> clazz) {
        this.clazz = clazz;
        createOptions();
    }

    private void createOptions() {
        E[] constants = clazz.getEnumConstants();
        options = new EnumFilterOption[constants.length + 1];

        for (int i = 0 ; i < constants.length; i++) {
            options[i] = new EnumFilterOption(constants[i]);
        }

        // create undefined option
        EnumFilterOption<E> undefined = new EnumFilterOption<E>();
        undefined.setValue(null);
        undefined.setUndefined(true);

        options[constants.length] = undefined;
    }

    public EnumFilterOption<E>[] getOptions() {
        return options;
    }
}
